package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * 单记录JOIN查询动作
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class SingleMybatisPlusQueryAction<E> extends AbstractMybatisPlusQueryAction<E, E> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> vefMapper;

  public SingleMybatisPlusQueryAction(
      JoinQueryWrapper<E> queryWrapper,
      ElsfsMapper<E> vefMapper,
      TableAliasManager tableAliasManager) {
    super(queryWrapper, tableAliasManager);
    this.vefMapper = vefMapper;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public E execute() {
    if (this.vefMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    this.limit(1);
    E entity = this.vefMapper.selectJoinOne(this.wrapper);
    return entity;
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected QueryAction<E> instance(Wrapper<E> wrapper) {
    return new SingleMybatisPlusQueryAction<>(
        CastUtils.cast(wrapper), null, this.tableAliasManager);
  }
}
