/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.abs.AbstractCondition;
import org.elsfs.tool.sql.abs.CompositeSqlFragment;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.common.FieldEnumResolverSupport;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mybatis.AbstractMybatisPlusQueryOperations;
import org.elsfs.tool.sql.singular.facade.ConditionFields;
import org.elsfs.tool.sql.singular.facade.EntityRelationDescriptor;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.SqlUtils;

public abstract class AbstractMybatisPlusQueryAction<E, R>
extends AbstractMybatisPlusQueryOperations<QueryAction<R>, E>
implements QueryAction<R> {
    protected final JoinQueryWrapper<E> queryWrapper;
    protected final TableAliasManager tableAliasManager;

    protected AbstractMybatisPlusQueryAction(JoinQueryWrapper<E> queryWrapper, TableAliasManager tableAliasManager) {
        super(queryWrapper);
        this.queryWrapper = queryWrapper;
        this.tableAliasManager = tableAliasManager;
    }

    @Override
    public String resolveFieldName(Enum<?> field) {
        return FieldEnumResolverSupport.resolveFieldName((TableAliasManager)this.tableAliasManager, field);
    }

    @Override
    public String resolveFieldName(String tableAlias, Enum<?> field) {
        return tableAlias + "." + field.name();
    }

    @Override
    protected Query<?, E, String> query() {
        return this.queryWrapper;
    }

    public ConditionFields getConditionFields() {
        String conditionSql = this.queryWrapper.getTargetSql();
        if (StrUtils.isBlank((String)conditionSql)) {
            return new ConditionFields(Collections.emptySet(), this.tableAliasManager);
        }
        return new ConditionFields(SqlUtils.parseConditionSqlColumnNames((String)conditionSql), this.tableAliasManager);
    }

    public QueryAction<R> clearDefaultSelectedFields() {
        this.queryWrapper.clearDefaultSelectedFields();
        return this;
    }

    public QueryAction<R> associate(EntityRelationDescriptor relationDescriptor) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)relationDescriptor.getEntityClass());
        return (QueryAction)((QueryAction.ActionJoinConditionBuilder)((QueryAction.ActionJoinConditionBuilder)((QueryAction.ActionSelectJoinBuilder)this.leftJoin(relationDescriptor.getEntityClass()).select((String[])relationDescriptor.getSelectionFields().toArray(String[]::new))).on()).eq("t." + relationDescriptor.getForeignKeyField(), this.tableAliasManager.fetchTableAlias(tableInfo.getTableName()) + "." + (StrUtils.isBlank((String)relationDescriptor.getJoinKeyField()) ? tableInfo.getKeyColumn() : relationDescriptor.getJoinKeyField()))).end();
    }

    public String buildSqlFragment() {
        return this.queryWrapper.buildSqlFragment();
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(Class<?> entityClass) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(entityClass));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(entityClass, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(Class<?> entityClass, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(entityClass, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(String table, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(table, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(String table) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(table));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(String table, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(table, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> join(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.join(sqlBuilderConsumer, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(Class<?> entityClass, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(entityClass, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(Class<?> entityClass) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(entityClass));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(String table) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(table));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(entityClass, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(String table, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(table, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(String table, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(table, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> leftJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.leftJoin(sqlBuilderConsumer, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(Class<?> entityClass) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(entityClass));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(Class<?> entityClass, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(entityClass, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(entityClass, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(String table) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(table));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(String table, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(table, tableAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(String table, String tableAlias, boolean registerAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(table, tableAlias, registerAlias));
    }

    public QueryAction.ActionSelectJoinBuilder<R> rightJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return new ActionSelectJoinBuilderImpl(this.queryWrapper.rightJoin(sqlBuilderConsumer, tableAlias));
    }

    public class ActionSelectJoinBuilderImpl
    extends CompositeSqlFragment
    implements QueryAction.ActionSelectJoinBuilder<R> {
        private final JoinQueryWrapper.WrapperSelectJoinBuilderImpl delegate;

        public ActionSelectJoinBuilderImpl(JoinQueryWrapper.WrapperSelectJoinBuilderImpl delegate) {
            this.delegate = delegate;
        }

        public QueryAction<R> end() {
            return AbstractMybatisPlusQueryAction.this;
        }

        public QueryAction.ActionJoinConditionBuilder<R> on() {
            return new ActionJoinConditionConfigurerImpl(this, (JoinQueryWrapper.WrapperSelectJoinBuilderImpl.WrapperJoinConditionBuilderImpl)this.delegate.on());
        }

        public QueryAction.ActionSelectJoinBuilder<R> select(Enum<?> ... fields) {
            this.delegate.select(fields);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> select(String ... fields) {
            this.delegate.select(fields);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> select(Collection<String> fields) {
            this.delegate.select(fields);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectExpression(String ... expressions) {
            this.delegate.selectExpression(expressions);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectExpression(Collection<String> expressions) {
            this.delegate.selectExpression(expressions);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectAs(String field, String fieldAlias) {
            this.delegate.selectAs(field, fieldAlias);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectAs(Enum<?> field, String fieldAlias) {
            this.delegate.selectAs(field, fieldAlias);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectAs(Enum<?> field, Enum<?> fieldAlias) {
            this.delegate.selectAs(field, fieldAlias);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, String fieldAlias) {
            this.delegate.selectAs(sqlBuilderConsumer, fieldAlias);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, Enum<?> fieldAlias) {
            this.delegate.selectAs(sqlBuilderConsumer, fieldAlias);
            return this;
        }

        public QueryAction.ActionSelectJoinBuilder<R> selectEnum(Collection<Enum<?>> fields) {
            this.delegate.selectEnum(fields);
            return this;
        }

        public static class ActionJoinConditionConfigurerImpl
        extends AbstractCondition<QueryAction.ActionJoinConditionBuilder<R>>
        implements QueryAction.ActionJoinConditionBuilder<R> {
            private final JoinQueryWrapper.WrapperJoinConditionBuilderImpl delegate;
            final /* synthetic */ ActionSelectJoinBuilderImpl this$1;

            public ActionJoinConditionConfigurerImpl(JoinQueryWrapper.WrapperJoinConditionBuilderImpl delegate) {
                this.this$1 = this$1;
                this.delegate = delegate;
            }

            protected void addConditionItem(ConditionItem conditionItem) {
                this.delegate.addConditionItem(conditionItem);
            }

            public QueryAction<R> end() {
                return this.this$1.end();
            }

            public SqlParameterManager getSqlParameterManager() {
                return this.delegate.getSqlParameterManager();
            }

            public TableAliasManager getTableAliasManager() {
                return this.delegate.getTableAliasManager();
            }
        }
    }
}

