package org.elsfs.tool.sql.conditions.interfaces;

import java.util.function.Consumer;

/**
 * 应用action消费器
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.1
 */
public interface ApplySql<Children> {

  /**
   * 应用action消费器
   *
   * @param actionConsumer action消费器
   * @return 具体实现
   */
  Children apply(Consumer<Children> actionConsumer);

  /**
   * 应用action消费器
   *
   * @param condition 条件
   * @param actionConsumer action消费器
   * @return 具体实现
   */
  Children apply(boolean condition, Consumer<Children> actionConsumer);
}
