package org.elsfs.tool.sql.conditions.interfaces;

/**
 * exists
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Exists<Children> {

  /**
   * 拼接 EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: exists("select id from table where age = 1")
   *
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children exists(String sqlValue, Object... values);

  /**
   * 拼接 EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: exists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children exists(boolean condition, String sqlValue, Object... values);
}
