package org.elsfs.tool.sql.conditions.interfaces;

/**
 * 拼接 sql
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface ExpressionSql<Children> {

  /**
   * 拼接 sql
   *
   * <p>!! 会有 sql 注入风险 !!
   *
   * <p>例1: expression("id = 1")
   *
   * <p>例2: expression("date_format(dateColumn,'%Y-%m-%d') = '2008-08-08'")
   *
   * <p>例3: expression("date_format(dateColumn,'%Y-%m-%d') = {0}", LocalDate.now())
   *
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children expression(String sqlValue, Object... values);

  /**
   * 拼接 sql
   *
   * <p>!! 会有 sql 注入风险 !!
   *
   * <p>例1: expression("id = 1")
   *
   * <p>例2: expression("date_format(dateColumn,'%Y-%m-%d') = '2008-08-08'")
   *
   * <p>例3: expression("date_format(dateColumn,'%Y-%m-%d') = {0}", LocalDate.now())
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children expression(boolean condition, String sqlValue, Object... values);
}
