package org.elsfs.tool.sql.conditions.interfaces;

/**
 * isNotNull
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface IsNotNull<Children> {
  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param field 字段
   * @return children
   */
  Children isNotNull(String field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param field 字段枚举
   * @return children
   */
  Children isNotNull(Enum<?> field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  Children isNotNull(String tableAlias, Enum<?> field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  Children isNotNull(boolean condition, String field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  Children isNotNull(boolean condition, Enum<?> field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  Children isNotNull(boolean condition, String tableAlias, Enum<?> field);
}
