package org.elsfs.tool.sql.conditions.interfaces;

/**
 * the is {@link Le}
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Le<Children> {

  /**
   * 小于等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  default Children le(String field, Object value) {
    return le(true, field, value);
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, String field, Object value);

  /**
   * 小于等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children le(Enum<?> field, Object value) {
    return le(true, field, value);
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, Enum<?> field, Object value);

  /**
   * 小于等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children le(String tableAlias, Enum<?> field, Object value) {
    return le(true, tableAlias, field, value);
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children leSql(String field, String sqlValue) {
    return leSql(true, field, sqlValue);
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children leSql(Enum<?> field, String sqlValue) {
    return leSql(true, field, sqlValue);
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children leSql(String tableAlias, Enum<?> field, String sqlValue) {
    return leSql(true, tableAlias, field, sqlValue);
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);
}
