package org.elsfs.tool.sql.conditions.interfaces;

/**
 * 小于
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Lt<Children> {

  /**
   * 小于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  default Children lt(String field, Object value) {
    return lt(true, field, value);
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children lt(boolean condition, String field, Object value);

  /**
   * 小于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children lt(Enum<?> field, Object value) {
    return lt(true, field, value);
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children lt(boolean condition, Enum<?> field, Object value);

  /**
   * 小于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children lt(String tableAlias, Enum<?> field, Object value) {
    return lt(true, tableAlias, field, value);
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children lt(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children ltSql(String field, String sqlValue) {
    return ltSql(true, field, sqlValue);
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children ltSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children ltSql(Enum<?> field, String sqlValue) {
    return ltSql(true, field, sqlValue);
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children ltSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children ltSql(String tableAlias, Enum<?> field, String sqlValue) {
    return ltSql(true, tableAlias, field, sqlValue);
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children ltSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);
}
