package org.elsfs.tool.sql.conditions.interfaces;

/**
 * 不等于
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Ne<Children> {

  /**
   * 不等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  default Children ne(String field, Object value) {
    return ne(true, field, value);
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, String field, Object value);

  /**
   * 不等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ne(Enum<?> field, Object value) {
    return ne(true, field, value);
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, Enum<?> field, Object value);

  /**
   * 不等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ne(String tableAlias, Enum<?> field, Object value) {
    return ne(true, tableAlias, field, value);
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, String tableAlias, Enum<?> field, Object value);
}
