package org.elsfs.tool.sql.conditions.interfaces;

/**
 * notExists
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface NotExists<Children> {
  /**
   * 拼接 NOT EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: notExists("select id from table where age = 1")
   *
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children notExists(String sqlValue, Object... values);

  /**
   * 拼接 NOT EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: notExists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children notExists(boolean condition, String sqlValue, Object... values);
}
