package org.elsfs.tool.sql.conditions.interfaces;

/**
 * notLike
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface NotLike<Children> {

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children notLike(boolean condition, String field, Object value);

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children notLike(boolean condition, Enum<?> field, Object value);

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children notLike(boolean condition, String tableAlias, Enum<?> field, Object value);
}
