package org.elsfs.tool.sql.conditions.interfaces;

import java.util.function.Consumer;

/**
 * or
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Or<Children> {

  /**
   * 拼接 OR
   *
   * @return children
   */
  Children or();

  /**
   * 拼接 OR
   *
   * @param condition 执行条件
   * @return children
   */
  Children or(boolean condition);

  /**
   * OR 嵌套
   *
   * <p>例: or(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  Children or(Consumer<Children> consumer);

  /**
   * OR 嵌套
   *
   * <p>例: or(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children or(boolean condition, Consumer<Children> consumer);
}
