package org.elsfs.tool.sql.conditions.interfaces;

import java.util.function.Consumer;

/**
 * AND 嵌套
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface And<Children> {

  /**
   * AND 嵌套
   *
   * <p>例: and(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  default Children and(Consumer<Children> consumer) {
    return and(true, consumer);
  }

  /**
   * AND 嵌套
   *
   * <p>例: and(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children and(boolean condition, Consumer<Children> consumer);
}
