package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 之间
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Between<Children> extends ResolveFieldName {

  /**
   * 范围
   *
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children between(String field, Object leftValue, Object rightValue) {
    return between(true, field, leftValue, rightValue);
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(boolean condition, String field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children between(Enum<?> field, Object leftValue, Object rightValue) {
    return between(true, field, leftValue, rightValue);
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children between(boolean condition, Enum<?> field, Object leftValue, Object rightValue) {
    return between(condition, resolveFieldName(field), leftValue, rightValue);
  }

  /**
   * 范围
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children between(String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    return between(true, tableAlias, field, leftValue, rightValue);
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children between(
      boolean condition, String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    return between(condition, resolveFieldName(tableAlias, field), leftValue, rightValue);
  }
}
