package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 等于
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Eq<Children> extends ResolveFieldName {

  /**
   * 等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  default Children eq(String field, Object value) {
    return eq(true, field, value);
  }

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children eq(boolean condition, String field, Object value);

  /**
   * 等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children eq(Enum<?> field, Object value) {
    return eq(true, field, value);
  }

  /**
   * 等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  public default Children eq(boolean condition, Enum<?> field, Object value) {
    return this.eq(condition, resolveFieldName(field), value);
  }

  /**
   * 等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children eq(String tableAlias, Enum<?> field, Object value) {
    return eq(true, tableAlias, field, value);
  }

  /**
   * 等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children eq(boolean condition, String tableAlias, Enum<?> field, Object value) {
    return eq(condition, this.resolveFieldName(tableAlias, field), value);
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children eqSql(String field, String sqlValue) {
    return eqSql(true, field, sqlValue);
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children eqSql(Enum<?> field, String sqlValue) {
    return eqSql(true, field, sqlValue);
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children eqSql(boolean condition, Enum<?> field, String sqlValue) {
    return eqSql(condition, resolveFieldName(field), sqlValue);
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children eqSql(String tableAlias, Enum<?> field, String sqlValue) {
    return eqSql(true, tableAlias, field, sqlValue);
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children eqSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    return eqSql(condition, resolveFieldName(tableAlias, field), sqlValue);
  }
}
