package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * ge
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Ge<Children> extends ResolveFieldName {

  /**
   * 大于等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  default Children ge(String field, Object value) {
    return ge(true, field, value);
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ge(boolean condition, String field, Object value);

  /**
   * 大于等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ge(Enum<?> field, Object value) {
    return ge(true, field, value);
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ge(boolean condition, Enum<?> field, Object value) {
    return ge(condition, resolveFieldName(field), value);
  }

  /**
   * 大于等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ge(String tableAlias, Enum<?> field, Object value) {
    return ge(true, tableAlias, field, value);
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children ge(boolean condition, String tableAlias, Enum<?> field, Object value) {
    return ge(condition, resolveFieldName(tableAlias, field), value);
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children geSql(String field, String sqlValue) {
    return geSql(true, field, sqlValue);
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children geSql(Enum<?> field, String sqlValue) {
    return geSql(true, field, sqlValue);
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children geSql(boolean condition, Enum<?> field, String sqlValue) {
    return ge(condition, resolveFieldName(field), sqlValue);
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children geSql(String tableAlias, Enum<?> field, String sqlValue) {
    return geSql(true, tableAlias, field, sqlValue);
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  default Children geSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    return ge(condition, resolveFieldName(tableAlias, field), sqlValue);
  }
}
