package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * isNotNull
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface IsNotNull<Children> extends ResolveFieldName {

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param field 字段
   * @return children
   */
  default Children isNotNull(String field) {
    return isNotNull(true, field);
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param field 字段枚举
   * @return children
   */
  default Children isNotNull(Enum<?> field) {
    return isNotNull(true, field);
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  default Children isNotNull(String tableAlias, Enum<?> field) {
    return isNotNull(true, tableAlias, field);
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  Children isNotNull(boolean condition, String field);

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  default Children isNotNull(boolean condition, Enum<?> field) {
    return isNotNull(condition, resolveFieldName(field));
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  default Children isNotNull(boolean condition, String tableAlias, Enum<?> field) {
    return isNotNull(condition, resolveFieldName(tableAlias, field));
  }
}
