package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * isNull
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface IsNull<Children> extends ResolveFieldName {

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param field 字段
   * @return children
   */
  default Children isNull(String field) {
    return isNull(true, field);
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param field 字段枚举
   * @return children
   */
  default Children isNull(Enum<?> field) {
    return isNull(true, field);
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  default Children isNull(String tableAlias, Enum<?> field) {
    return isNull(true, tableAlias, field);
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  Children isNull(boolean condition, String field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  default Children isNull(boolean condition, Enum<?> field) {
    return isNull(condition, resolveFieldName(field));
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  default Children isNull(boolean condition, String tableAlias, Enum<?> field) {
    return isNull(condition, resolveFieldName(tableAlias, field));
  }
}
