package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * like
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Like<Children> extends ResolveFieldName {

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children like(boolean condition, String field, Object value);

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children like(boolean condition, Enum<?> field, Object value) {
    return like(condition, resolveFieldName(field), value);
  }

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children like(boolean condition, String tableAlias, Enum<?> field, Object value) {
    return like(condition, resolveFieldName(tableAlias, field), value);
  }
}
