package org.elsfs.tool.sql.conditions.interfaces;

import java.util.function.Consumer;

/**
 * meted
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface Nested<Children> {

  /**
   * 正常嵌套 不带 AND 或者 OR
   *
   * <p>例: nested(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  default Children nested(Consumer<Children> consumer) {
    return nested(true, consumer);
  }

  /**
   * 正常嵌套 不带 AND 或者 OR
   *
   * <p>例: nested(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children nested(boolean condition, Consumer<Children> consumer);
}
