package org.elsfs.tool.sql.conditions.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * not betewee
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface NotBetween<Children> extends ResolveFieldName {

  /**
   * 不在范围
   *
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children notBetween(String field, Object leftValue, Object rightValue) {
    return notBetween(true, field, leftValue, rightValue);
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children notBetween(boolean condition, String field, Object leftValue, Object rightValue);

  /**
   * 不在范围
   *
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children notBetween(Enum<?> field, Object leftValue, Object rightValue) {
    return notBetween(true, field, leftValue, rightValue);
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, Enum<?> field, Object leftValue, Object rightValue) {
    return notBetween(condition, resolveFieldName(field), leftValue, rightValue);
  }

  /**
   * 不在范围
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children notBetween(
      String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    return notBetween(true, tableAlias, field, leftValue, rightValue);
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    return notBetween(condition, resolveFieldName(tableAlias, field), leftValue, rightValue);
  }
}
