package org.elsfs.tool.sql.conditions.interfaces;

import java.util.Collection;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * not in
 *
 * @param <Children> 继承的类型
 * @author zeng
 * @since 0.0.2
 */
public interface NotIn<Children> extends ResolveFieldName {

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值集合
   * @return 具体实现
   */
  Children notIn(boolean condition, String field, Collection<?> values);

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  default Children notIn(boolean condition, Enum<?> field, Collection<?> values) {
    return notIn(condition, resolveFieldName(field), values);
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  default Children notIn(
      boolean condition, String tableAlias, Enum<?> field, Collection<?> values) {
    return notIn(condition, resolveFieldName(tableAlias, field), values);
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值数组
   * @return 具体实现
   */
  Children notIn(boolean condition, String field, Object... values);

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  default Children notIn(boolean condition, Enum<?> field, Object... values) {
    return notIn(condition, resolveFieldName(field), values);
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  default Children notIn(boolean condition, String tableAlias, Enum<?> field, Object... values) {
    return notIn(condition, resolveFieldName(tableAlias, field), values);
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param field 字段
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  default Children notInSql(String field, String sqlValue) {
    return notInSql(true, field, sqlValue);
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  default Children notInSql(Enum<?> field, String sqlValue) {
    return notInSql(true, field, sqlValue);
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  default Children notInSql(String tableAlias, Enum<?> field, String sqlValue) {
    return notInSql(true, resolveFieldName(tableAlias, field), sqlValue);
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  Children notInSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  default Children notInSql(boolean condition, Enum<?> field, String sqlValue) {
    return notInSql(condition, resolveFieldName(field), sqlValue);
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  default Children notInSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    return notInSql(condition, resolveFieldName(tableAlias, field), sqlValue);
  }
}
