package org.elsfs.tool.sql.conditions.update;

import java.util.function.Supplier;
import org.elsfs.tool.sql.conditions.Condition;

/**
 * 更新操作
 *
 * @author zeng
 * @since 0.0.3
 */
public interface UpdateCondition<R> extends Condition<UpdateCondition<R>>, Supplier<R> {

  /**
   * 设置值
   *
   * @param field 表字段名
   * @param value 值
   * @return 具体实现
   */
  default UpdateCondition<R> set(String field, Object value) {
    return set(true, field, value);
  }

  /**
   * 设置值
   *
   * @param field 表字段枚举
   * @param value 值
   * @return 具体实现
   */
  default UpdateCondition<R> set(Enum<?> field, Object value) {
    return this.set(this.resolveFieldName(field), value);
  }

  /**
   * 设置值
   *
   * @param condition 是否应用设置
   * @param field 表字段名
   * @param value 值
   * @return 具体实现
   */
  UpdateCondition<R> set(boolean condition, String field, Object value);

  /**
   * 设置值
   *
   * @param condition 是否应用设置
   * @param field 表字段枚举
   * @param value 值
   * @return 具体实现
   */
  default UpdateCondition<R> set(boolean condition, Enum<?> field, Object value) {
    return this.set(condition, this.resolveFieldName(field), value);
  }

  /**
   * 设置SQL
   *
   * @param sqlValue SQL片段：name=xxx
   * @return 具体实现
   */
  default UpdateCondition<R> setSql(String sqlValue) {
    return this.setSql(true, sqlValue);
  }

  /**
   * 设置SQL
   *
   * @param condition 是否应用设置SQL
   * @param sqlValue SQL片段：name=xxx
   * @return 具体实现
   */
  UpdateCondition<R> setSql(boolean condition, String sqlValue);
}
