package org.elsfs.tool.sql.resolve;

/**
 * 解析字段枚举名称
 *
 * @author zeng
 * @since 0.0.3
 */
public interface ResolveFieldName {

  /**
   * 解析字段枚举名称
   *
   * @param field 字段枚举
   * @return 字段名称
   */
  String resolveFieldName(Enum<?> field);

  /**
   * 解析字段枚举名称
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 字段名称
   */
  String resolveFieldName(String tableAlias, Enum<?> field);
}
