package org.elsfs.tool.sql.builder;

import org.elsfs.tool.sql.abs.AbstractSelectSql;
import org.elsfs.tool.sql.common.SimpleSqlParameterManager;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;

/**
 * 通用查询SQL实现
 *
 * @author zeng
 * @version 0.0.4
 */
public abstract class GenericSelectSql<C extends GenericSelectSql<C>> extends AbstractSelectSql<C> {

  /** SQL参数管理器 */
  private final SqlParameterManager sqlParameterManager = new SimpleSqlParameterManager();

  /** 表别名管理器 */
  private final TableAliasManager tableAliasManager = new SimpleTableAliasManager();

  /**
   * 获取SQL参数管理器
   *
   * @return SQL参数管理器
   */
  @Override
  public SqlParameterManager getSqlParameterManager() {
    return this.sqlParameterManager;
  }

  /**
   * 获取表别名管理器
   *
   * @return 表名别管理器
   */
  @Override
  public TableAliasManager getTableAliasManager() {
    return this.tableAliasManager;
  }
}
