package org.elsfs.tool.sql.common;

import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 字段枚举解析支持类
 *
 * @author zeng
 * @version 0.0.4
 */
public final class FieldEnumResolverSupport {

  /**
   * 解析字段枚举名称
   *
   * @param tableAliasManager 表别名管理器
   * @param field 字段枚举
   * @return 字段名称
   */
  public static String resolveFieldName(TableAliasManager tableAliasManager, Enum<?> field) {
    Class<?> enclosingClass = field.getClass().getEnclosingClass();
    //        if (enclosingClass != null && AbstractEntity.class.isAssignableFrom(enclosingClass)) {
    String tableAlias = tableAliasManager.fetchTableAlias(enclosingClass);
    if (StrUtils.isNotBlank(tableAlias)) {
      return tableAlias + SqlPool.DOT + field.name();
    }

    return field.name();
  }
}
