package org.elsfs.tool.sql.common;

import java.util.HashMap;
import java.util.Map;
import org.elsfs.tool.sql.interfaces.TableAliasManager;

/**
 * 简单表别名管理器
 *
 * @author zeng
 * @version 0.0.4
 */
public class SimpleTableAliasManager implements TableAliasManager {

  /** 别名Map */
  private final Map<String, String> aliasMap = new HashMap<>();

  /** 计数器 */
  private int index;

  /**
   * 生成表别名
   *
   * @param entityClass 表实体类
   * @return 别名
   */
  @Override
  public String generateAlias(Class<?> entityClass) {
    return this.generateAlias(
        // TODO   TableInfoHelper.getTableInfo(entityClass).getTableName()
        "");
  }

  /**
   * 生成表别名
   *
   * @param table 数据库表名
   * @return 别名
   */
  @Override
  public String generateAlias(String table) {
    if (this.aliasMap.containsKey(table)) {
      return this.aliasMap.get(table);
    }

    String alias;
    do {
      alias = "t" + this.index++;
    } while (this.aliasMap.containsKey(alias));

    this.aliasMap.put(table, alias);
    return alias;
  }

  /**
   * 注册表别名
   *
   * @param entityClass 表实体类
   * @param alias 别名
   */
  @Override
  public void registerAlias(Class<?> entityClass, String alias) {
    this.aliasMap.put(
        // TODO   TableInfoHelper.getTableInfo(entityClass).getTableName()
        "", alias);
  }

  /**
   * 注册表别名
   *
   * @param table 数据库表名
   * @param alias 别名
   */
  @Override
  public void registerAlias(String table, String alias) {
    this.aliasMap.put(table, alias);
  }

  /**
   * 获取表别名
   *
   * @param entityClass 表实体类
   * @return 表别名
   */
  @Override
  public String fetchTableAlias(Class<?> entityClass) {
    return this.fetchTableAlias(
        // TODO   TableInfoHelper.getTableInfo(entityClass).getTableName()
        "");
  }

  /**
   * 获取表别名
   *
   * @param table 数据库表名
   * @return 表别名
   */
  @Override
  public String fetchTableAlias(String table) {
    return this.aliasMap.get(table);
  }
}
