package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * And条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class AndConditionItem implements ConditionItem {

  /** 条件项 */
  private final ConditionItem conditionItem;

  public AndConditionItem(ConditionItem conditionItem) {
    this.conditionItem = conditionItem;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("AND {}", this.conditionItem.buildSqlFragment());
  }
}
