package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.util.CharSequenceUtil;
import org.elsfs.tool.sql.interfaces.SqlFragment;

/**
 * 条件项
 *
 * @author zeng
 * @version 0.0.4
 */
public interface ConditionItem extends SqlFragment {

  /**
   * 剔除条件SQL头部多余的关键词
   *
   * @param conditionSql 条件SQL
   * @return 合理的条件SQL
   */
  static String stripHeaderKeywordStatic(String conditionSql) {
    if (conditionSql.startsWith("AND ")) {
      return CharSequenceUtil.strip(conditionSql, "AND ");
    }

    if (conditionSql.startsWith("OR ")) {
      return CharSequenceUtil.strip(conditionSql, "OR ");
    }

    return conditionSql;
  }

  /**
   * 剔除条件SQL头部多余的关键词
   *
   * @param conditionSql 条件SQL
   * @return 合理的条件SQL
   */
  default String stripHeaderKeyword(String conditionSql) {
    if (conditionSql.startsWith("AND ")) {
      return CharSequenceUtil.strip(conditionSql, "AND ");
    }

    if (conditionSql.startsWith("OR ")) {
      return CharSequenceUtil.strip(conditionSql, "OR ");
    }

    return conditionSql;
  }
}
