package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;

/**
 * 字段条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class FieldConditionItem implements ConditionItem {

  /** 左边字段名称 */
  private final String leftField;

  /** 右边字段名称 */
  private final String rightField;

  /** 比较操作符 */
  private final CompareOperator compareOperator;

  /**
   * 构造方法
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @param compareOperator 比较操作符
   */
  public FieldConditionItem(String leftField, String rightField, CompareOperator compareOperator) {
    this.leftField = leftField;
    this.rightField = rightField;
    this.compareOperator = compareOperator;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return NamingCase.toUnderlineCase(this.leftField)
        + this.compareOperator.getOperator()
        + NamingCase.toUnderlineCase(this.rightField);
  }
}
