package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 为空条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class IsNotNullConditionItem extends IsNullConditionItem {

  public IsNotNullConditionItem(String field) {
    super(field);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("{} IS NOT NULL", NamingCase.toUnderlineCase(this.field));
  }
}
