package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 非区间开始值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotBetweenBeginValueConditionItem extends BetweenBeginValueConditionItem {

  public NotBetweenBeginValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Object beginValue,
      String endField) {
    super(sqlParameterManager, leftField, beginValue, endField);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} NOT BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.beginValue)),
        NamingCase.toUnderlineCase(this.endField));
  }
}
