package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 非区间结束值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotBetweenEndValueConditionItem extends BetweenEndValueConditionItem {

  public NotBetweenEndValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      String beginField,
      Object endValue) {
    super(sqlParameterManager, leftField, beginField, endValue);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} NOT BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        NamingCase.toUnderlineCase(this.beginField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.endValue)));
  }
}
