package org.elsfs.tool.sql.condition;

import java.util.Collection;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 不在范围条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotInConditionItem extends InConditionItem {

  public NotInConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Collection<String> inFields,
      Collection<?> inValues) {
    super(sqlParameterManager, leftField, inFields, inValues);
  }

  /**
   * 构建SQL片段
   *
   * @param token IN部分SQL
   * @return SQL片段
   */
  @Override
  protected String buildSqlFragment(String token) {
    return StrFormatter.format("{} NOT IN ({})", NamingCase.toUnderlineCase(this.leftField), token);
  }
}
