package org.elsfs.tool.sql.delete;

import java.util.Collection;
import java.util.stream.Collectors;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 聚合删除项
 *
 * @author zeng
 * @version 0.0.4
 */
public class CompositeDeleteItem implements DeleteItem {

  /** 删除项集合 */
  private final Collection<DeleteItem> deleteItems;

  public CompositeDeleteItem(Collection<DeleteItem> deleteItems) {
    this.deleteItems = deleteItems;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return this.deleteItems.stream()
        .map(SqlFragment::buildSqlFragment)
        .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE));
  }
}
