package org.elsfs.tool.sql.executor;

import org.elsfs.tool.sql.builder.GenericInsertSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 插入SQL执行器
 *
 * @author zeng
 * @version 0.0.4
 */
public class InsertSqlExecutor extends GenericInsertSql<InsertSqlExecutor>
    implements SqlExecutor<Integer> {

  public InsertSqlExecutor(GenericSqlExecutor genericSqlExecutor) {
    this.genericSqlExecutor = genericSqlExecutor;
  }

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public Integer execute() {
    return this.genericSqlExecutor.insert(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters());
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // TODO
    return null;
  }
}
