package org.elsfs.tool.sql.from;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 子查询From项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class SubQueryFromItem implements FromItem {

  /** 子查询SQL */
  private final String subQuerySql;

  /** 表别名 */
  private final String tableAlias;

  public SubQueryFromItem(String subQuerySql, String tableAlias) {
    this.subQuerySql = subQuerySql;
    this.tableAlias = tableAlias;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("FROM ({}) AS {}", this.subQuerySql, this.tableAlias);
  }

  /**
   * 获取表别名
   *
   * @return 表别名
   */
  @Override
  public String getTableAlias() {
    return tableAlias;
  }
}
