package org.elsfs.tool.sql.interfaces;

import java.util.Map;

/**
 * 参数化SQL
 *
 * @author zeng
 * @since 0.0.4
 */
public class ParameterizedSql {

  /** SQL */
  private final String sql;

  /** SQL参数 */
  private final Map<String, Object> parameters;

  public ParameterizedSql(String sql, Map<String, Object> parameters) {
    this.sql = sql;
    this.parameters = parameters;
  }

  public String getSql() {
    return sql;
  }

  public Map<String, Object> getParameters() {
    return parameters;
  }
}
