package org.elsfs.tool.sql.interfaces;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;

/**
 * 联合查询SQL
 *
 * @param <C> 子类具体类型
 * @author zeng
 * @since 0.0.4
 */
public interface UnionSql<C extends UnionSql<C>> extends SqlFragment {

  /**
   * 联合（去重和排序）
   *
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  C union(Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 粗暴联合
   *
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  C unionAll(Consumer<StandardSelectSql> sqlBuilderConsumer);
}
