package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link JoinIsNull}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinIsNull<Children> extends ResolveFieldName {

  /**
   * 为空条件
   *
   * @param field 字段名称
   * @return 具体实现
   */
  Children isNull(String field);

  /**
   * 为空条件
   *
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNull(Enum<?> field) {
    return this.isNull(this.resolveFieldName(field));
  }

  /**
   * 为空条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNull(String tableAlias, Enum<?> field) {
    return this.isNull(this.resolveFieldName(tableAlias, field));
  }

  /**
   * 为空条件
   *
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children isNull(Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 为空条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @return 具体实现
   */
  default Children isNull(boolean condition, String field) {
    if (condition) {
      return this.isNull(field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 为空条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNull(boolean condition, Enum<?> field) {
    if (condition) {
      return this.isNull(field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 为空条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNull(boolean condition, String tableAlias, Enum<?> field) {
    if (condition) {
      return this.isNull(tableAlias, field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 为空条件
   *
   * @param condition 条件
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children isNull(boolean condition, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    if (condition) {
      return this.isNull(sqlBuilderConsumer);
    }

    return CastUtils.cast(this);
  }
}
