package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 不等于
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNe<Children> extends ResolveFieldName {

  /**
   * 不相等条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ne(String leftField, String rightField) {
    return ne(true, leftField, rightField);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children ne(boolean condition, String leftField, String rightField);

  /**
   * 不相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(Enum<?> leftField, Enum<?> rightField) {
    return ne(true, resolveFieldName(leftField), resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return ne(
        resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return ne(resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return ne(resolveFieldName(leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(String leftField, Enum<?> rightField) {
    return ne(leftField, resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(String leftField, String rightTableAlias, Enum<?> rightField) {
    return ne(leftField, resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ne(Enum<?> leftField, String rightField) {
    return ne(true, leftField, rightField);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ne(boolean condition, Enum<?> leftField, String rightField) {
    return ne(condition, resolveFieldName(leftField), rightField);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return ne(condition, resolveFieldName(leftField), resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ne(String leftTableAlias, Enum<?> leftField, String rightField) {
    return ne(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ne(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return ne(condition, resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return ne(
        condition,
        resolveFieldName(leftTableAlias, leftField),
        resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return ne(condition, resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return ne(
        condition, resolveFieldName(leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(boolean condition, String leftField, Enum<?> rightField) {
    return ne(condition, leftField, resolveFieldName(rightField));
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ne(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return ne(condition, leftField, resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ne(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ne(resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ne(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ne(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children ne(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 不相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ne(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ne(resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ne(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ne(condition, resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ne(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ne(condition, resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 不相等条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children neValue(String leftField, Object rightValue) {
    return neValue(true, leftField, rightValue);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children neValue(boolean condition, String leftField, Object rightValue);

  /**
   * 不相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children neValue(Enum<?> leftField, Object rightValue) {
    return neValue(true, leftField, rightValue);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children neValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return neValue(condition, resolveFieldName(leftField), rightValue);
  }

  /**
   * 不相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children neValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return neValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 不相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children neValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return neValue(condition, resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
