package org.elsfs.tool.sql.interfaces.select;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.interfaces.Completable;
import org.elsfs.tool.sql.interfaces.SqlFragment;

/**
 * 查询SQL
 *
 * @param <C> 子类具体类型
 * @param <H> Having条件构建器类型
 * @param <S> 选择条件构建器类型
 * @author zeng
 * @since 0.0.4
 */
public interface SelectSql<
        C extends SelectSql<C, S, H>,
        S extends SelectSql.SelectConditionBuilder<S, H, C>,
        H extends SelectCondition.HavingConditionBuilder<H, S>>
    extends Selectable<C>, SqlFragment {

  /**
   * 设置查询表
   *
   * @param entityClass 实体类
   * @return 具体实现
   */
  C from(Class<?> entityClass);

  /**
   * 设置查询表
   *
   * @param table 表名
   * @return 具体实现
   */
  C from(String table);

  /**
   * 设置查询表
   *
   * @param entityClass 实体类
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C from(Class<?> entityClass, String tableAlias);

  /**
   * 设置查询表
   *
   * @param table 表名
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C from(String table, String tableAlias);

  /**
   * 设置子查询表
   *
   * @param sqlBuilderConsumer SQL构建器消费器
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C from(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias);

  /**
   * 设置Where条件
   *
   * @return 条件构建器
   */
  SelectConditionBuilder<S, H, C> where();

  /**
   * 查询条件构建器
   *
   * @param <C> 具体实现类型
   * @param <H> 分组条件构建器类型
   * @param <P> 上级对象类型
   */
  interface SelectConditionBuilder<
          C extends SelectConditionBuilder<C, H, P>,
          H extends SelectCondition.HavingConditionBuilder<H, C>,
          P extends SelectSql<P, C, H>>
      extends SelectCondition<C, H>, Completable<P> {}
}
