package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link Ge}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Ge<Children> {

  /**
   * 大于等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ge(String field, Object value);

  /**
   * 大于等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ge(Enum<?> field, Object value);

  /**
   * 大于等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ge(String tableAlias, Enum<?> field, Object value);

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ge(boolean condition, String field, Object value);

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ge(boolean condition, Enum<?> field, Object value);

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ge(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(String field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(Enum<?> field, String sqlValue);

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children geSql(String tableAlias, Enum<?> field, String sqlValue);
}
