package org.elsfs.tool.sql.interfaces.single;

import java.util.Collection;

/**
 * the is {@link In}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface In<Children> {

  /**
   * 范围匹配
   *
   * @param field 字段名
   * @param values 值集合
   * @return 具体实现
   */
  Children in(String field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  Children in(Enum<?> field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  Children in(String tableAlias, Enum<?> field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param field 字段名
   * @param values 值数组
   * @return 具体实现
   */
  Children in(String field, Object... values);

  /**
   * 范围匹配
   *
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  Children in(Enum<?> field, Object... values);

  /**
   * 范围匹配
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  Children in(String tableAlias, Enum<?> field, Object... values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值集合
   * @return 具体实现
   */
  Children in(boolean condition, String field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  Children in(boolean condition, Enum<?> field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  Children in(boolean condition, String tableAlias, Enum<?> field, Collection<?> values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值数组
   * @return 具体实现
   */
  Children in(boolean condition, String field, Object... values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  Children in(boolean condition, Enum<?> field, Object... values);

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  Children in(boolean condition, String tableAlias, Enum<?> field, Object... values);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param field 字段
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(String field, String sqlValue);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(Enum<?> field, String sqlValue);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(String tableAlias, Enum<?> field, String sqlValue);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  Children inSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);
}
