package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link Like}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Like<Children> {

  /**
   * 模糊匹配
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children like(String field, Object value);

  /**
   * 模糊匹配
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children like(Enum<?> field, Object value);

  /**
   * 模糊匹配
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children like(String tableAlias, Enum<?> field, Object value);

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children like(boolean condition, String field, Object value);

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children like(boolean condition, Enum<?> field, Object value);

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children like(boolean condition, String tableAlias, Enum<?> field, Object value);
}
