package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link LikeLeft}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface LikeLeft<Children> {

  /**
   * 左模糊匹配
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(String field, Object value);

  /**
   * 左模糊匹配
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(Enum<?> field, Object value);

  /**
   * 左模糊匹配
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(String tableAlias, Enum<?> field, Object value);

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(boolean condition, String field, Object value);

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(boolean condition, Enum<?> field, Object value);

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeLeft(boolean condition, String tableAlias, Enum<?> field, Object value);
}
