package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link LikeRight}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface LikeRight<Children> {

  /**
   * 右模糊匹配
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(String field, Object value);

  /**
   * 右模糊匹配
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(Enum<?> field, Object value);

  /**
   * 右模糊匹配
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(String tableAlias, Enum<?> field, Object value);

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(boolean condition, String field, Object value);

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(boolean condition, Enum<?> field, Object value);

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children likeRight(boolean condition, String tableAlias, Enum<?> field, Object value);
}
