package org.elsfs.tool.sql.interfaces.update;

import java.util.Map;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * 可设值接口
 *
 * @param <C> 子类类型
 * @author zeng
 * @since 0.0.4
 */
public interface Settable<C extends Settable<C>> {

  /**
   * 设置字段表达式
   *
   * @param field 字段名称
   * @param expression 表达式
   * @param args 表达式参数
   * @return 具体实现
   */
  C set(String field, String expression, Object... args);

  /**
   * 设置字段表达式
   *
   * @param field 字段枚举
   * @param expression 表达式
   * @param args 表达式参数
   * @return 具体实现
   */
  C set(Enum<?> field, String expression, Object... args);

  /**
   * 设置字段表达式
   *
   * @param condition 条件
   * @param field 字段名称
   * @param expression 表达式
   * @return 具体实现
   */
  default C set(boolean condition, String field, String expression) {
    if (condition) {
      return this.set(field, expression);
    }

    return CastUtils.cast(this);
  }

  /**
   * 设置字段表达式
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param expression 表达式
   * @return 具体实现
   */
  default C set(boolean condition, Enum<?> field, String expression) {
    if (condition) {
      return this.set(field, expression);
    }

    return CastUtils.cast(this);
  }

  /**
   * 设置字段值
   *
   * @param field 字段名称
   * @param value 值
   * @return 具体实现
   */
  C setValue(String field, Object value);

  /**
   * 设置字段值
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  C setValue(Enum<?> field, Object value);

  /**
   * 设置字段值
   *
   * @param condition 条件
   * @param field 字段名称
   * @param value 值
   * @return 具体实现
   */
  default C setValue(boolean condition, String field, Object value) {
    if (condition) {
      return this.setValue(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 设置字段值
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default C setValue(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.setValue(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 批量设置字段值
   *
   * @param fieldValueMap 字段值Map
   * @return 具体实现
   */
  C setValues(Map<String, Object> fieldValueMap);

  /**
   * 批量设置字段值
   *
   * @param condition 条件
   * @param fieldValueMap 字段值Map
   * @return 具体实现
   */
  default C setValues(boolean condition, Map<String, Object> fieldValueMap) {
    if (condition) {
      return this.setValues(fieldValueMap);
    }

    return CastUtils.cast(this);
  }

  /**
   * 批量设置字段值
   *
   * @param fieldValueMap 字段枚举值Map
   * @return 具体实现
   */
  C setValuesEnum(Map<Enum<?>, Object> fieldValueMap);

  /**
   * 批量设置字段值
   *
   * @param condition 条件
   * @param fieldValueMap 字段枚举值Map
   * @return 具体实现
   */
  default C setValuesEnum(boolean condition, Map<Enum<?>, Object> fieldValueMap) {
    if (condition) {
      return this.setValuesEnum(fieldValueMap);
    }

    return CastUtils.cast(this);
  }
}
