package org.elsfs.tool.sql.limit;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 标准限制数量实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardLimitItem implements LimitItem {

  /** 限制数量 */
  private final long number;

  public StandardLimitItem(long number) {
    this.number = number;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("LIMIT {}", this.number);
  }
}
