package org.elsfs.tool.sql.order;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 升序排序
 *
 * @author zeng
 * @version 0.0.4
 */
public class AscOrderItem implements OrderItem {

  /** 字段名称 */
  private final String field;

  public AscOrderItem(String field) {
    this.field = field;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("{} ASC", NamingCase.toUnderlineCase(this.field));
  }
}
